#ifndef __CVstExceptionHandler__
#define __CVstExceptionHandler__

//	===========================================================================

#include <Exceptions/CException.hpp>
#include <Basics/CSystemString.hpp>
#include "CHostCanDo.hpp"

//	===========================================================================

using Exponent::Basics::CSystemString;
using Exponent::Exceptions::CException;
using Exponent::Vst::CHostCanDo;

//	===========================================================================

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @class CVstExceptionHandler CVstExceptionHandler.hpp
		 * @brief Handles exceptions inside a VSt, and prints / saves certain handy information
		 *
		 * @date 02/07/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Added FPU system information
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: CVstExceptionHandler.hpp,v 1.4 2007/02/08 21:08:23 paul Exp $
		 */
		class CVstExceptionHandler
		{
		public:

			/**
			 * Handle the exception
			 * @param exception THe exception you recieved
			 * @param canDo What is the host information
			 * @param path The path to write a log file to
			 */
			static void handleException(CException exception, const CHostCanDo &canDo, const CSystemString &path);

			/**
			 * Handle the exception without VSt information
			 * @param exception THe exception you recieved
			 * @param path The path to write a log file to
			 */
			static void preVstExceptionHandler(CException exception, const CSystemString &path);
		};
	}
}
#endif	// End of CVstExceptionHandler.hpp